<?php

namespace App\Http\Controllers;

use App\Models\User;
use App\Models\Document;
use Illuminate\Http\Request;

class AdminController extends Controller
{
    public function index()
    {
        // Fetch users with pending profiles or documents
        $users = User::with(['workerProfile', 'clientProfile', 'documents'])
            ->where('role', '!=', 'admin')
            ->get();

        return response()->json($users);
    }

    public function verifyDocument(Request $request, Document $document)
    {
        $request->validate([
            'status' => 'required|in:approved,rejected',
            'rejection_reason' => 'required_if:status,rejected',
        ]);

        $document->update([
            'status' => $request->status,
            'rejection_reason' => $request->rejection_reason,
        ]);

        return response()->json(['message' => 'Document status updated']);
    }

    public function verifyUser(Request $request, User $user)
    {
        $request->validate([
            'status' => 'required|in:active,suspended',
        ]);

        $user->update(['status' => $request->status]);

        // Also update profile status
        if ($user->workerProfile) {
            $user->workerProfile()->update(['verification_status' => $request->status === 'active' ? 'verified' : 'rejected']);
        } elseif ($user->clientProfile) {
            $user->clientProfile()->update(['verification_status' => $request->status === 'active' ? 'verified' : 'rejected']);
        }

        return response()->json(['message' => 'User status updated']);
    }
}
