<?php

namespace App\Http\Controllers;

use App\Models\SystemSetting;
use Illuminate\Http\Request;

class AdminSettingsController extends Controller
{
    public function index()
    {
        // Return key-value pairs
        $settings = SystemSetting::where('group', 'stripe')->pluck('value', 'key');
        return response()->json($settings);
    }

    public function update(Request $request)
    {
        $request->validate([
            'mode' => 'required|in:sandbox,live',
            'test_pk' => 'nullable|string',
            'test_sk' => 'nullable|string',
            'live_pk' => 'nullable|string',
            'live_sk' => 'nullable|string',
        ]);

        $settings = [
            'stripe_mode' => $request->mode,
            'stripe_test_public_key' => $request->test_pk,
            'stripe_test_secret_key' => $request->test_sk,
            'stripe_live_public_key' => $request->live_pk,
            'stripe_live_secret_key' => $request->live_sk,
        ];

        foreach ($settings as $key => $value) {
            SystemSetting::updateOrCreate(
                ['key' => $key],
                ['value' => $value, 'group' => 'stripe']
            );
        }

        return response()->json(['message' => 'Settings updated successfully']);
    }
}
