<?php

namespace App\Http\Controllers;

use App\Models\Document;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class DocumentController extends Controller
{
    public function index(Request $request)
    {
        return $request->user()->documents;
    }

    public function store(Request $request)
    {
        $request->validate([
            'type' => 'required|string',
            'file' => 'required|file|mimes:pdf,jpg,jpeg,png|max:10240', // 10MB max
            'expiry_date' => 'nullable|date',
        ]);

        $path = $request->file('file')->store('documents', 'public');

        $document = $request->user()->documents()->create([
            'type' => $request->type,
            'file_path' => $path,
            'expiry_date' => $request->expiry_date,
            'status' => 'pending',
        ]);

        return response()->json($document, 201);
    }

    public function destroy(Document $document, Request $request)
    {
        if ($document->user_id !== $request->user()->id) {
            return response()->json(['message' => 'Unauthorized'], 403);
        }

        Storage::disk('public')->delete($document->file_path);
        $document->delete();

        return response()->json(['message' => 'Document deleted']);
    }
}
