<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class ProfileController extends Controller
{
    public function show(Request $request)
    {
        $user = $request->user()->load(['workerProfile', 'clientProfile']);
        return response()->json($user);
    }

    public function updateWorker(Request $request)
    {
        $user = $request->user();

        if ($user->role !== 'worker') {
            return response()->json(['message' => 'Unauthorized'], 403);
        }

        $validated = $request->validate([
            'job_role' => 'nullable|string',
            'bio' => 'nullable|string',
            'experience_years' => 'nullable|integer',
            'ni_number' => 'nullable|string',
            'transport_mode' => 'nullable|string',
            'max_travel_distance' => 'nullable|integer',
        ]);

        $user->workerProfile()->updateOrCreate(
            ['user_id' => $user->id],
            $validated
        );

        return response()->json(['message' => 'Profile updated successfully', 'user' => $user->load('workerProfile')]);
    }

    public function updateClient(Request $request)
    {
        $user = $request->user();

        if ($user->role !== 'client') {
            return response()->json(['message' => 'Unauthorized'], 403);
        }

        $validated = $request->validate([
            'company_name' => 'nullable|string',
            'company_reg_no' => 'nullable|string',
            'cqc_location_id' => 'nullable|string',
            'address' => 'nullable|string',
            'postcode' => 'nullable|string',
            'contact_person' => 'nullable|string',
        ]);

        $user->clientProfile()->updateOrCreate(
            ['user_id' => $user->id],
            $validated
        );

        return response()->json(['message' => 'Profile updated successfully', 'user' => $user->load('clientProfile')]);
    }
}
