<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\JobPosting;
use App\Models\User;

class Booking extends Model
{
    protected $fillable = [
        'job_id',
        'worker_id',
        'status', // applied, approved, rejected, completed_pending_review, completed_approved, disputed
        'actual_start_time',
        'actual_end_time',
        'break_minutes',
    ];

    protected $casts = [
        'actual_start_time' => 'datetime',
        'actual_end_time' => 'datetime',
    ];

    public function job()
    {
        return $this->belongsTo(JobPosting::class, 'job_id');
    }

    public function worker()
    {
        return $this->belongsTo(User::class, 'worker_id');
    }
}
