<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class JobPosting extends Model
{
    use HasFactory;

    protected $fillable = [
        'client_id',
        'title',
        'role_type',
        'description',
        'location',
        'postcode',
        'start_time',
        'end_time',
        'rate_per_hour',
        'status',
        'requirements',
    ];

    protected function casts(): array
    {
        return [
            'start_time' => 'datetime',
            'end_time' => 'datetime',
            'requirements' => 'array',
        ];
    }

    public function client()
    {
        return $this->belongsTo(User::class, 'client_id');
    }
}
