<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class WorkerProfile extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'job_role',
        'bio',
        'experience_years',
        'ni_number',
        'transport_mode',
        'max_travel_distance',
        'verification_status',
        'bank_details_encrypted',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
