<?php

namespace App\Services;

use App\Models\SystemSetting;
use Stripe\StripeClient;

class StripeService
{
    protected $stripe;
    protected $mode;

    public function __construct()
    {
        $this->mode = SystemSetting::where('key', 'stripe_mode')->value('value') ?? 'sandbox';
        
        if ($this->mode === 'live') {
            $key = SystemSetting::where('key', 'stripe_live_secret_key')->value('value');
        } else {
            $key = SystemSetting::where('key', 'stripe_test_secret_key')->value('value');
        }

        if ($key) {
            $this->stripe = new StripeClient($key);
        }
    }

    public function isMockMode()
    {
        return !$this->stripe;
    }

    public function createPaymentIntent($amount, $currency = 'gbp', $metadata = [])
    {
        if ($this->isMockMode()) {
            return (object) [
                'id' => 'pi_mock_' . uniqid(),
                'client_secret' => 'mock_secret_' . uniqid(),
                'status' => 'succeeded',
                'amount' => $amount,
            ];
        }

        return $this->stripe->paymentIntents->create([
            'amount' => $amount,
            'currency' => $currency,
            'automatic_payment_methods' => ['enabled' => true],
            'metadata' => $metadata,
        ]);
    }

    public function createAccountLink($accountId)
    {
        if ($this->isMockMode()) {
            return (object) [
                'url' => route('worker.dashboard') . '?mock_onboarding=success',
            ];
        }
        
        // ... (Real implementation would go here)
        return null; 
    }
}
