<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('worker_profiles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->onDelete('cascade');
            $table->string('job_role')->nullable(); // nurse, carer, cook
            $table->text('bio')->nullable();
            $table->integer('experience_years')->nullable();
            $table->string('ni_number')->nullable(); // National Insurance
            $table->string('transport_mode')->nullable(); // car, public
            $table->integer('max_travel_distance')->nullable(); // in miles
            $table->string('verification_status')->default('pending'); // pending, verified, rejected
            $table->text('bank_details_encrypted')->nullable(); // Placeholder for now
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('worker_profiles');
    }
};
