<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('job_postings', function (Blueprint $table) {
            $table->id();
            $table->foreignId('client_id')->constrained('users')->onDelete('cascade'); // Client is a user
            $table->string('title');
            $table->string('role_type'); // nurse, carer
            $table->text('description')->nullable();
            $table->string('location');
            $table->string('postcode');
            $table->dateTime('start_time');
            $table->dateTime('end_time');
            $table->decimal('rate_per_hour', 8, 2);
            $table->string('status')->default('draft'); // draft, open, filled, completed, cancelled
            $table->json('requirements')->nullable(); // e.g. ["dbs_enhanced", "nmc_pin"]
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('job_postings');
    }
};
