/*!
 * vue-router v5.0.2
 * (c) 2026 Eduardo San Martin Morote
 * @license MIT
 */
import { _ as DataLoaderPluginOptions, a as DefineLoaderFn, b as useIsDataLoading, c as UseDataLoaderResult, f as getCurrentContext, g as DataLoaderPlugin, h as withLoaderContext, i as DefineDataLoaderOptionsBase_LaxData, l as toLazyValue, m as trackRoute, n as DataLoaderEntryBase, o as UseDataLoader, p as setCurrentContext, r as DefineDataLoaderOptionsBase_DefinedData, s as UseDataLoaderInternals, t as DataLoaderContextBase, u as ErrorDefault, v as NavigationResult, y as SetupLoaderGuardOptions } from "../index-CUL6Z3eo.mjs";
import { $ as MatcherPatternPathDynamic_ParamOptions, A as EXPERIMENTAL_RouteRecord_Group, B as MatcherPatternQueryParam, Bn as TypesConfig, D as EXPERIMENTAL_RouteRecordNormalized_Matchable, E as EXPERIMENTAL_RouteRecordNormalized_Group, F as EXPERIMENTAL_Router_Base, G as PARAM_PARSER_BOOL, H as definePathParamParser, I as experimental_createRouter, J as MatcherParamsFormatted, L as normalizeRouteRecord, M as EXPERIMENTAL_Router, N as EXPERIMENTAL_RouterOptions, O as EXPERIMENTAL_RouteRecordRaw, P as EXPERIMENTAL_RouterOptions_Base, Q as MatcherPatternPathDynamic, R as createFixedResolver, T as EXPERIMENTAL_RouteRecordNormalized, U as defineQueryParamParser, V as defineParamParser, W as PARAM_PARSER_INT, X as MatcherPatternHash, Y as MatcherPattern, Z as MatcherPatternPath, bn as RouteRecordRaw, en as RouteMap, et as MatcherPatternPathStatic, j as EXPERIMENTAL_RouteRecord_Matchable, jt as RouteLocationNormalizedLoaded, k as EXPERIMENTAL_RouteRecord_Base, nt as MatcherQueryParamsValue, q as EmptyParams, rt as ParamParser, tt as MatcherQueryParams, z as MatcherPatternQuery } from "../index-Cu9B0wDz.mjs";

//#region src/experimental/route-resolver/matchers/errors.d.ts
/**
 * Error throw when a matcher matches by regex but validation fails.
 */
declare class MatchMiss extends Error {
  name: string;
}
/**
 * Helper to create a {@link MatchMiss} error.
 * @param args - Arguments to pass to the `MatchMiss` constructor.
 *
 * @example
 * ```ts
 * throw miss()
 * // in a number param matcher
 * throw miss('Number must be finite')
 * ```
 */
declare const miss: (...args: ConstructorParameters<typeof MatchMiss>) => MatchMiss;
//#endregion
//#region src/experimental/runtime.d.ts
/**
 * Helper to define page properties with file-based routing.
 * **Doesn't do anything**, used for types only.
 *
 * @param route - route information to be added to this page
 *
 * @internal
 */
declare const definePage: (route: DefinePage) => DefinePage;
/**
 * Merges route records.
 *
 * @internal
 *
 * @param main - main route record
 * @param routeRecords - route records to merge
 * @returns merged route record
 */
declare function _mergeRouteRecord(main: RouteRecordRaw, ...routeRecords: Partial<RouteRecordRaw>[]): RouteRecordRaw;
/**
 * Type to define a page. Can be augmented to add custom properties.
 */
interface DefinePage extends Partial<Omit<RouteRecordRaw, 'children' | 'components' | 'component' | 'name'>> {
  /**
   * A route name. If not provided, the name will be generated based on the file path.
   * Can be set to `false` to remove the name from types.
   */
  name?: string | false;
  /**
   * Custom parameters for the route. Requires `experimental.paramParsers` enabled.
   *
   * @experimental
   */
  params?: {
    path?: Record<string, ParamParserType>;
    /**
     * Parameters extracted from the query.
     */
    query?: Record<string, DefinePageQueryParamOptions | ParamParserType>;
  };
}
type ParamParserType_Native = 'int' | 'bool';
type ParamParserType = (TypesConfig extends Record<'ParamParsers', infer ParamParsers> ? ParamParsers : never) | ParamParserType_Native;
/**
 * Configures how to extract a route param from a specific query parameter.
 */
interface DefinePageQueryParamOptions<T = unknown> {
  /**
   * The type of the query parameter. Allowed values are native param parsers
   * and any parser in the {@link https://uvr.esm.is/TODO | params folder }. If
   * not provided, the value will kept as is.
   */
  parser?: ParamParserType;
  /**
   * Default value if the query parameter is missing or if the match fails
   * (e.g. a invalid number is passed to the int param parser). If not provided
   * and the param is not required, the route will match with undefined.
   */
  default?: (() => T) | T;
  /**
   * How to format the query parameter value.
   *
   * - 'value' - keep the first value only and pass that to parser
   * - 'array' - keep all values (even one or none) as an array and pass that to parser
   *
   * @default 'value'
   */
  format?: 'value' | 'array';
  /**
   * Whether this query parameter is required. If true and the parameter is
   * missing (and no default is provided), the route will not match.
   *
   * @default false
   */
  required?: boolean;
}
//#endregion
//#region src/experimental/data-loaders/defineLoader.d.ts
/**
 * Creates a data loader composable that can be exported by pages to attach the data loading to a route. In this version `data` is always defined.
 *
 * @param name - name of the route
 * @param loader - function that returns a promise with the data
 * @param options - options to configure the data loader
 */
declare function defineBasicLoader<Name extends keyof RouteMap, Data>(name: Name, loader: DefineLoaderFn<Data, DataLoaderContext, RouteLocationNormalizedLoaded<Name>>, options?: DefineDataLoaderOptions_DefinedData): UseDataLoaderBasic_DefinedData<Data>;
/**
 * Creates a data loader composable that can be exported by pages to attach the data loading to a route. In this version, `data` can be `undefined`.
 *
 * @param name - name of the route
 * @param loader - function that returns a promise with the data
 * @param options - options to configure the data loader
 */
declare function defineBasicLoader<Name extends keyof RouteMap, Data>(name: Name, loader: DefineLoaderFn<Data, DataLoaderContext, RouteLocationNormalizedLoaded<Name>>, options: DefineDataLoaderOptions_LaxData): UseDataLoaderBasic_LaxData<Data>;
/**
 * Creates a data loader composable that can be exported by pages to attach the data loading to a route. In this version `data` is always defined.
 *
 * @param loader - function that returns a promise with the data
 * @param options - options to configure the data loader
 */
declare function defineBasicLoader<Data>(loader: DefineLoaderFn<Data, DataLoaderContext, RouteLocationNormalizedLoaded>, options?: DefineDataLoaderOptions_DefinedData): UseDataLoaderBasic_DefinedData<Data>;
/**
 * Creates a data loader composable that can be exported by pages to attach the data loading to a route. In this version, `data` can be `undefined`.
 *
 * @param loader - function that returns a promise with the data
 * @param options - options to configure the data loader
 */
declare function defineBasicLoader<Data>(loader: DefineLoaderFn<Data, DataLoaderContext, RouteLocationNormalizedLoaded>, options: DefineDataLoaderOptions_LaxData): UseDataLoaderBasic_LaxData<Data>;
interface DefineDataLoaderOptions_LaxData extends DefineDataLoaderOptionsBase_LaxData {
  /**
   * Key to use for SSR state. This will be used to read the initial data from `initialData`'s object.
   */
  key?: string;
}
interface DefineDataLoaderOptions_DefinedData extends DefineDataLoaderOptionsBase_DefinedData {
  key?: string;
}
/**
 * @deprecated use {@link DefineDataLoaderOptions_LaxData} instead
 */
type DefineDataLoaderOptions = DefineDataLoaderOptions_LaxData;
interface DataLoaderContext extends DataLoaderContextBase {}
/**
 * Symbol used to store the data in the router so it can be retrieved after the initial navigation.
 * @internal
 */
declare const SERVER_INITIAL_DATA_KEY: unique symbol;
/**
 * Initial data generated on server and consumed on client.
 * @internal
 */
declare const INITIAL_DATA_KEY: unique symbol;
declare module '../../router' {
  interface Router {
    /**
     * Gives access to the initial state during rendering. Should be set to `false` once it's consumed.
     * @internal
     */
    [SERVER_INITIAL_DATA_KEY]?: Record<string, unknown> | false;
    [INITIAL_DATA_KEY]?: Record<string, unknown> | false;
  }
}
interface UseDataLoaderBasic_LaxData<Data> extends UseDataLoader<Data | undefined, ErrorDefault> {}
/**
 * @deprecated use {@link UseDataLoaderBasic_LaxData} instead
 */
type UseDataLoaderBasic<Data> = UseDataLoaderBasic_LaxData<Data>;
interface UseDataLoaderBasic_DefinedData<Data> extends UseDataLoader<Data, ErrorDefault> {}
interface DataLoaderBasicEntry<TData, TError = unknown, TDataInitial extends TData | undefined = TData | undefined> extends DataLoaderEntryBase<TData, TError, TDataInitial> {}
//#endregion
export { type DataLoaderBasicEntry, type DataLoaderContext, type DataLoaderContextBase, type DataLoaderEntryBase, DataLoaderPlugin, type DataLoaderPluginOptions, type DefineDataLoaderOptions, type DefineDataLoaderOptionsBase_DefinedData, type DefineDataLoaderOptionsBase_LaxData, type DefineDataLoaderOptions_DefinedData, type DefineDataLoaderOptions_LaxData, type DefineLoaderFn, type DefinePage, type DefinePageQueryParamOptions, type EXPERIMENTAL_RouteRecordNormalized, type EXPERIMENTAL_RouteRecordNormalized_Group, type EXPERIMENTAL_RouteRecordNormalized_Matchable, type EXPERIMENTAL_RouteRecordRaw, type EXPERIMENTAL_RouteRecord_Base, type EXPERIMENTAL_RouteRecord_Group, type EXPERIMENTAL_RouteRecord_Matchable, type EXPERIMENTAL_Router, type EXPERIMENTAL_RouterOptions, type EXPERIMENTAL_RouterOptions_Base, type EXPERIMENTAL_Router_Base, type EmptyParams, type ErrorDefault, MatchMiss, type MatcherParamsFormatted, type MatcherPattern, type MatcherPatternHash, type MatcherPatternPath, MatcherPatternPathDynamic, type MatcherPatternPathDynamic_ParamOptions, MatcherPatternPathStatic, type MatcherPatternQuery, MatcherPatternQueryParam, type MatcherQueryParams, type MatcherQueryParamsValue, NavigationResult, PARAM_PARSER_BOOL, PARAM_PARSER_INT, type ParamParser, type ParamParserType, type ParamParserType_Native, type SetupLoaderGuardOptions, type UseDataLoader, type UseDataLoaderBasic, type UseDataLoaderBasic_DefinedData, type UseDataLoaderBasic_LaxData, type UseDataLoaderInternals, type UseDataLoaderResult, _mergeRouteRecord, createFixedResolver, defineBasicLoader, definePage, defineParamParser, definePathParamParser, defineQueryParamParser, experimental_createRouter, getCurrentContext, miss, normalizeRouteRecord, setCurrentContext, toLazyValue, trackRoute, useIsDataLoading, withLoaderContext };