import type { Router, RouteRecordRaw } from 'vue-router'

/**
 * Array of routes generated by vue-router file based routing
 */
export declare const routes: readonly RouteRecordRaw[]

/**
 * Setups hot module replacement for routes.
 *
 * @param router - The router instance
 * @param hotUpdateCallback - Callback to be called after replacing the routes and before the navigation
 *
 * @example
 *
 * ```ts
 * import { createRouter, createWebHistory } from 'vue-router'
 * import { routes, handleHotUpdate } from 'vue-router/auto-routes'
 * const router = createRouter({
 *   history: createWebHistory(),
 *   routes,
 * })
 * if (import.meta.hot) {
 *   handleHotUpdate(router)
 * }
 * ```
 */
export declare function handleHotUpdate(
  router: Router,
  hotUpdateCallback?: (newRoutes: RouteRecordRaw[]) => void
): void

// TODO: rename to RouteMap and move directly into vue-router so
// it can be extended with declare module 'vue-router'
export interface RouteNamedMap {}

declare module 'vue-router' {
  interface TypesConfig {
    RouteNamedMap: RouteNamedMap
  }
}

// Make the macros globally available
declare global {
  const definePage: (typeof import('vue-router/experimental'))['definePage']
}
