<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\PasswordResetController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

// Public routes
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);

// Password Reset Routes
Route::post('/forgot-password', [PasswordResetController::class, 'sendResetLink']);
Route::post('/reset-password', [PasswordResetController::class, 'reset']);

// Protected routes
Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
    Route::get('/user', [AuthController::class, 'user']);
    
    // Profile Routes
    Route::get('/profile', [\App\Http\Controllers\ProfileController::class, 'show']);
    Route::post('/profile/worker', [\App\Http\Controllers\ProfileController::class, 'updateWorker']);
    Route::post('/profile/client', [\App\Http\Controllers\ProfileController::class, 'updateClient']);
    
    // Document Routes
    Route::get('/documents', [\App\Http\Controllers\DocumentController::class, 'index']);
    Route::post('/documents', [\App\Http\Controllers\DocumentController::class, 'store']);
    Route::delete('/documents/{document}', [\App\Http\Controllers\DocumentController::class, 'destroy']);

    // Admin Routes
    Route::middleware('can:admin')->group(function () {
        Route::get('/admin/users', [\App\Http\Controllers\AdminController::class, 'index']);
        Route::post('/admin/documents/{document}/verify', [\App\Http\Controllers\AdminController::class, 'verifyDocument']);
        Route::post('/admin/users/{user}/verify', [\App\Http\Controllers\AdminController::class, 'verifyUser']);
        
        // Settings
        Route::get('/admin/settings/stripe', [\App\Http\Controllers\AdminSettingsController::class, 'index']);
        Route::post('/admin/settings/stripe', [\App\Http\Controllers\AdminSettingsController::class, 'update']);
    });

    // Job Routes
    Route::get('/jobs', [\App\Http\Controllers\JobController::class, 'index']); // Public search
    Route::post('/jobs', [\App\Http\Controllers\JobController::class, 'store']); // Client post
    Route::get('/my-jobs', [\App\Http\Controllers\JobController::class, 'myJobs']); // Client list

    // Booking Routes
    Route::get('/bookings', [\App\Http\Controllers\BookingController::class, 'index']);
    Route::post('/jobs/{job}/apply', [\App\Http\Controllers\BookingController::class, 'apply']);
    Route::post('/bookings/{booking}/accept', [\App\Http\Controllers\BookingController::class, 'accept']);
    Route::post('/bookings/{booking}/timesheet', [\App\Http\Controllers\BookingController::class, 'submitTimesheet']);
    Route::post('/bookings/{booking}/approve', [\App\Http\Controllers\BookingController::class, 'approveTimesheet']);

    // Payment Routes
    Route::post('/bookings/{booking}/pay', [\App\Http\Controllers\PaymentController::class, 'createPaymentIntent']);
    Route::post('/bookings/{booking}/confirm-payment', [\App\Http\Controllers\PaymentController::class, 'confirmPayment']);

    // Review Routes
    Route::post('/bookings/{booking}/review', [\App\Http\Controllers\ReviewController::class, 'store']);
    Route::get('/reviews', [\App\Http\Controllers\ReviewController::class, 'index']);
});
